/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class ClearColourRecipe
extends CustomRecipe {
    public ClearColourRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        boolean hasColourable = false;
        boolean hasSponge = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof IColouredItem) {
                IColouredItem colourable = (IColouredItem)item;
                if (hasColourable) {
                    return false;
                }
                if (colourable.getColour(stack) == -1) {
                    return false;
                }
                hasColourable = true;
                continue;
            }
            if (stack.m_41720_() == Items.f_41903_) {
                if (hasSponge) {
                    return false;
                }
                hasSponge = true;
                continue;
            }
            return false;
        }
        return hasColourable && hasSponge;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack colourable = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!(stack.m_41720_() instanceof IColouredItem)) continue;
            colourable = stack;
        }
        if (colourable.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ((IColouredItem)colourable.m_41720_()).withColour(colourable, -1);
        stack.m_41764_(1);
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remaining = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining.size(); ++i) {
            if (container.m_8020_(i).m_41720_() != Items.f_41903_) continue;
            remaining.set(i, (Object)new ItemStack((ItemLike)Items.f_41903_));
        }
        return remaining;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<ClearColourRecipe> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.DYEABLE_ITEM_CLEAR.get();
    }
}

